/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.shaded.bouncycastle.asn1.bc;

import com.easywebmap.shaded.bouncycastle.asn1.ASN1BitString;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1EncodableVector;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Object;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1OctetString;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Primitive;
import com.easywebmap.shaded.bouncycastle.asn1.ASN1Sequence;
import com.easywebmap.shaded.bouncycastle.asn1.DERBitString;
import com.easywebmap.shaded.bouncycastle.asn1.DEROctetString;
import com.easywebmap.shaded.bouncycastle.asn1.DERSequence;
import com.easywebmap.shaded.bouncycastle.asn1.x509.AlgorithmIdentifier;
import com.easywebmap.shaded.bouncycastle.asn1.x509.GeneralName;
import com.easywebmap.shaded.bouncycastle.asn1.x509.GeneralNames;
import com.easywebmap.shaded.bouncycastle.util.Arrays;

public class ExternalValue
extends ASN1Object {
    private final GeneralNames location;
    private final AlgorithmIdentifier hashAlg;
    private final byte[] hashValue;

    public ExternalValue(GeneralName generalName, AlgorithmIdentifier algorithmIdentifier, byte[] byArray) {
        this.location = new GeneralNames(generalName);
        this.hashAlg = algorithmIdentifier;
        this.hashValue = Arrays.clone(byArray);
    }

    private ExternalValue(ASN1Sequence aSN1Sequence) {
        if (aSN1Sequence.size() == 3) {
            this.location = GeneralNames.getInstance(aSN1Sequence.getObjectAt(0));
            this.hashAlg = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            this.hashValue = aSN1Sequence.getObjectAt(2) instanceof ASN1BitString ? ASN1BitString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets() : ASN1OctetString.getInstance(aSN1Sequence.getObjectAt(2)).getOctets();
        } else {
            throw new IllegalArgumentException("unknown sequence");
        }
    }

    public static ExternalValue getInstance(Object object) {
        if (object instanceof ExternalValue) {
            return (ExternalValue)object;
        }
        if (object != null) {
            return new ExternalValue(ASN1Sequence.getInstance(object));
        }
        return null;
    }

    public GeneralName getLocation() {
        return this.location.getNames()[0];
    }

    public GeneralName[] getLocations() {
        return this.location.getNames();
    }

    public AlgorithmIdentifier getHashAlg() {
        return this.hashAlg;
    }

    public byte[] getHashValue() {
        return Arrays.clone(this.hashValue);
    }

    public ASN1BitString getHashVal() {
        return new DERBitString(this.hashValue);
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.location);
        aSN1EncodableVector.add(this.hashAlg);
        aSN1EncodableVector.add(new DEROctetString(this.hashValue));
        return new DERSequence(aSN1EncodableVector);
    }
}

