/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.map;

import com.easywebmap.EasyWebMap;
import com.easywebmap.map.CompositeTileGenerator;
import com.easywebmap.map.DiskTileCache;
import com.easywebmap.map.PngDecoder;
import com.easywebmap.map.PngEncoder;
import com.easywebmap.map.TileCache;
import com.hypixel.hytale.math.util.ChunkUtil;
import com.hypixel.hytale.math.vector.Transform;
import com.hypixel.hytale.math.vector.Vector3d;
import com.hypixel.hytale.server.core.universe.PlayerRef;
import com.hypixel.hytale.server.core.universe.Universe;
import com.hypixel.hytale.server.core.universe.world.World;
import com.hypixel.hytale.server.core.universe.world.storage.ChunkStore;
import com.hypixel.hytale.server.core.universe.world.storage.IChunkLoader;
import com.hypixel.hytale.server.core.universe.world.worldmap.WorldMapManager;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Semaphore;

public class TileManager {
    private final EasyWebMap plugin;
    private final TileCache memoryCache;
    private final DiskTileCache diskCache;
    private final ConcurrentHashMap<String, CompletableFuture<byte[]>> pendingRequests;
    private final ConcurrentHashMap<String, CompletableFuture<PngEncoder.TileData>> pendingPixelRequests;
    private final ConcurrentHashMap<String, CachedChunkIndexes> chunkIndexCache;
    private final ConcurrentHashMap<String, PngEncoder.TileData> pixelCache;
    private CompositeTileGenerator compositeTileGenerator;
    private static final int MAX_PIXEL_CACHE = 2048;
    private static final int MAX_CONCURRENT_GENERATIONS = 16;
    private final Semaphore generationSemaphore = new Semaphore(16);
    private static final int EMPTY_TILE_THRESHOLD = 500;

    public TileManager(EasyWebMap plugin) {
        this.plugin = plugin;
        this.memoryCache = new TileCache(plugin.getConfig().getTileCacheSize());
        this.diskCache = new DiskTileCache(plugin.getDataDirectory());
        this.pendingRequests = new ConcurrentHashMap();
        this.pendingPixelRequests = new ConcurrentHashMap();
        this.chunkIndexCache = new ConcurrentHashMap();
        this.pixelCache = new ConcurrentHashMap();
        this.compositeTileGenerator = new CompositeTileGenerator(plugin, this);
    }

    public CompletableFuture<byte[]> getTile(String worldName, int zoom, int tileX, int tileZ) {
        if (zoom < 0 && this.plugin.getConfig().isEnableTilePyramids()) {
            return this.getCompositeTile(worldName, zoom, tileX, tileZ);
        }
        return this.getBaseTile(worldName, tileX, tileZ);
    }

    private CompletableFuture<byte[]> getCompositeTile(String worldName, int zoom, int tileX, int tileZ) {
        byte[] diskCached;
        String cacheKey = TileCache.createKey(worldName, zoom, tileX, tileZ);
        byte[] memoryCached = this.memoryCache.get(cacheKey);
        if (memoryCached != null) {
            return CompletableFuture.completedFuture(memoryCached);
        }
        CompletableFuture<byte[]> pending = this.pendingRequests.get(cacheKey);
        if (pending != null) {
            return pending;
        }
        if (this.plugin.getConfig().isUseDiskCache() && (diskCached = this.diskCache.get(worldName, zoom, tileX, tileZ)) != null) {
            long refreshInterval;
            long tileAge = this.diskCache.getTileAge(worldName, zoom, tileX, tileZ);
            if (tileAge < (refreshInterval = this.plugin.getConfig().getTileRefreshIntervalMs() * 2L)) {
                this.memoryCache.put(cacheKey, diskCached);
                return CompletableFuture.completedFuture(diskCached);
            }
            int chunksPerAxis = this.compositeTileGenerator.getChunksPerAxis(zoom);
            int baseChunkX = tileX * chunksPerAxis;
            int baseChunkZ = tileZ * chunksPerAxis;
            World world = Universe.get().getWorld(worldName);
            if (world == null || !this.arePlayersInArea(world, baseChunkX, baseChunkZ, chunksPerAxis)) {
                this.memoryCache.put(cacheKey, diskCached);
                return CompletableFuture.completedFuture(diskCached);
            }
        }
        CompletableFuture<byte[]> future = this.compositeTileGenerator.generateCompositeTile(worldName, zoom, tileX, tileZ);
        this.pendingRequests.put(cacheKey, future);
        future.whenComplete((data, ex) -> {
            this.pendingRequests.remove(cacheKey);
            if (data != null && ((byte[])data).length > 500 && ex == null) {
                this.memoryCache.put(cacheKey, (byte[])data);
                if (this.plugin.getConfig().isUseDiskCache()) {
                    this.diskCache.putAsync(worldName, zoom, tileX, tileZ, (byte[])data);
                }
            }
        });
        return future;
    }

    public CompletableFuture<byte[]> getBaseTile(String worldName, int tileX, int tileZ) {
        byte[] diskCached;
        String cacheKey = TileCache.createKey(worldName, 0, tileX, tileZ);
        byte[] memoryCached = this.memoryCache.get(cacheKey);
        if (memoryCached != null) {
            return CompletableFuture.completedFuture(memoryCached);
        }
        CompletableFuture<byte[]> pending = this.pendingRequests.get(cacheKey);
        if (pending != null) {
            return pending;
        }
        if (this.plugin.getConfig().isUseDiskCache() && (diskCached = this.diskCache.get(worldName, 0, tileX, tileZ)) != null) {
            long refreshInterval;
            long tileAge = this.diskCache.getTileAge(worldName, 0, tileX, tileZ);
            if (tileAge < (refreshInterval = this.plugin.getConfig().getTileRefreshIntervalMs())) {
                this.memoryCache.put(cacheKey, diskCached);
                return CompletableFuture.completedFuture(diskCached);
            }
            World world = Universe.get().getWorld(worldName);
            if (world == null || !this.arePlayersNearby(world, tileX, tileZ)) {
                this.memoryCache.put(cacheKey, diskCached);
                return CompletableFuture.completedFuture(diskCached);
            }
        }
        CompletableFuture<byte[]> future = this.generateTile(worldName, 0, tileX, tileZ);
        this.pendingRequests.put(cacheKey, future);
        future.whenComplete((data, ex) -> {
            this.pendingRequests.remove(cacheKey);
            if (data != null && ((byte[])data).length > 500 && ex == null) {
                this.memoryCache.put(cacheKey, (byte[])data);
                if (this.plugin.getConfig().isUseDiskCache()) {
                    this.diskCache.putAsync(worldName, 0, tileX, tileZ, (byte[])data);
                }
            }
        });
        return future;
    }

    public CompletableFuture<PngEncoder.TileData> getBaseTileWithPixels(String worldName, int tileX, int tileZ) {
        byte[] diskCached;
        String cacheKey = TileCache.createKey(worldName, 0, tileX, tileZ);
        int tileSize = this.plugin.getConfig().getTileSize();
        PngEncoder.TileData cached = this.pixelCache.get(cacheKey);
        if (cached != null) {
            return CompletableFuture.completedFuture(cached);
        }
        CompletableFuture<PngEncoder.TileData> pending = this.pendingPixelRequests.get(cacheKey);
        if (pending != null) {
            return pending;
        }
        if (this.plugin.getConfig().isUseDiskCache() && (diskCached = this.diskCache.get(worldName, 0, tileX, tileZ)) != null && diskCached.length > 500) {
            try {
                int[] pixels = PngDecoder.decode(diskCached, tileSize);
                if (pixels != null) {
                    PngEncoder.TileData tileData = new PngEncoder.TileData(diskCached, pixels, tileSize);
                    if (this.pixelCache.size() < 2048) {
                        this.pixelCache.put(cacheKey, tileData);
                    }
                    return CompletableFuture.completedFuture(tileData);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        CompletableFuture<PngEncoder.TileData> future = this.generateTileWithPixels(worldName, tileX, tileZ);
        this.pendingPixelRequests.put(cacheKey, future);
        future.whenComplete((data, ex) -> {
            this.pendingPixelRequests.remove(cacheKey);
            if (data != null && !data.isEmpty() && data.pngBytes.length > 500 && ex == null) {
                if (this.pixelCache.size() < 2048) {
                    this.pixelCache.put(cacheKey, (PngEncoder.TileData)data);
                }
                this.memoryCache.put(cacheKey, data.pngBytes);
                if (this.plugin.getConfig().isUseDiskCache()) {
                    this.diskCache.putAsync(worldName, 0, tileX, tileZ, data.pngBytes);
                }
            }
        });
        return future;
    }

    private CompletableFuture<PngEncoder.TileData> generateTileWithPixels(String worldName, int tileX, int tileZ) {
        World world = Universe.get().getWorld(worldName);
        int tileSize = this.plugin.getConfig().getTileSize();
        if (world == null) {
            return CompletableFuture.completedFuture(new PngEncoder.TileData(PngEncoder.encodeEmpty(tileSize), new int[0], tileSize));
        }
        if (this.plugin.getConfig().isRenderExploredChunksOnly() && !this.isChunkExplored(world, tileX, tileZ)) {
            return CompletableFuture.completedFuture(new PngEncoder.TileData(PngEncoder.encodeEmpty(tileSize), new int[0], tileSize));
        }
        WorldMapManager mapManager = world.getWorldMapManager();
        try {
            this.generationSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return CompletableFuture.completedFuture(new PngEncoder.TileData(PngEncoder.encodeEmpty(tileSize), new int[0], tileSize));
        }
        return ((CompletableFuture)((CompletableFuture)mapManager.getImageAsync(tileX, tileZ).thenApply(mapImage -> {
            if (mapImage == null) {
                return new PngEncoder.TileData(PngEncoder.encodeEmpty(tileSize), new int[0], tileSize);
            }
            return PngEncoder.encodeWithPixels(mapImage, tileSize);
        })).exceptionally(ex -> {
            System.err.println("[EasyWebMap] Failed to generate tile: " + ex.getMessage());
            return new PngEncoder.TileData(PngEncoder.encodeEmpty(tileSize), new int[0], tileSize);
        })).whenComplete((result, ex) -> this.generationSemaphore.release());
    }

    private boolean arePlayersNearby(World world, int tileX, int tileZ) {
        int radius = this.plugin.getConfig().getTileRefreshRadius();
        for (PlayerRef playerRef : world.getPlayerRefs()) {
            try {
                Transform transform = playerRef.getTransform();
                if (transform == null) continue;
                Vector3d pos = transform.getPosition();
                int playerChunkX = ChunkUtil.chunkCoordinate((int)((int)pos.x));
                int playerChunkZ = ChunkUtil.chunkCoordinate((int)((int)pos.z));
                int dx = Math.abs(playerChunkX - tileX);
                int dz = Math.abs(playerChunkZ - tileZ);
                if (dx > radius || dz > radius) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private boolean arePlayersInArea(World world, int baseChunkX, int baseChunkZ, int chunksPerAxis) {
        int radius = this.plugin.getConfig().getTileRefreshRadius();
        for (PlayerRef playerRef : world.getPlayerRefs()) {
            try {
                Transform transform = playerRef.getTransform();
                if (transform == null) continue;
                Vector3d pos = transform.getPosition();
                int playerChunkX = ChunkUtil.chunkCoordinate((int)((int)pos.x));
                int playerChunkZ = ChunkUtil.chunkCoordinate((int)((int)pos.z));
                if (playerChunkX < baseChunkX - radius || playerChunkX >= baseChunkX + chunksPerAxis + radius || playerChunkZ < baseChunkZ - radius || playerChunkZ >= baseChunkZ + chunksPerAxis + radius) continue;
                return true;
            }
            catch (Exception exception) {
            }
        }
        return false;
    }

    private CompletableFuture<byte[]> generateTile(String worldName, int zoom, int tileX, int tileZ) {
        World world = Universe.get().getWorld(worldName);
        if (world == null) {
            return CompletableFuture.completedFuture(PngEncoder.encodeEmpty(this.plugin.getConfig().getTileSize()));
        }
        if (this.plugin.getConfig().isRenderExploredChunksOnly() && !this.isChunkExplored(world, tileX, tileZ)) {
            return CompletableFuture.completedFuture(PngEncoder.encodeEmpty(this.plugin.getConfig().getTileSize()));
        }
        WorldMapManager mapManager = world.getWorldMapManager();
        try {
            this.generationSemaphore.acquire();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return CompletableFuture.completedFuture(PngEncoder.encodeEmpty(this.plugin.getConfig().getTileSize()));
        }
        return ((CompletableFuture)((CompletableFuture)mapManager.getImageAsync(tileX, tileZ).thenApply(mapImage -> {
            if (mapImage == null) {
                return PngEncoder.encodeEmpty(this.plugin.getConfig().getTileSize());
            }
            return PngEncoder.encode(mapImage, this.plugin.getConfig().getTileSize());
        })).exceptionally(ex -> {
            System.err.println("[EasyWebMap] Failed to generate tile: " + ex.getMessage());
            return PngEncoder.encodeEmpty(this.plugin.getConfig().getTileSize());
        })).whenComplete((result, ex) -> this.generationSemaphore.release());
    }

    private boolean isChunkExplored(World world, int chunkX, int chunkZ) {
        try {
            LongSet indexes = this.getCachedChunkIndexes(world);
            if (indexes == null) {
                return true;
            }
            long chunkIndex = ChunkUtil.indexChunk((int)chunkX, (int)chunkZ);
            return indexes.contains(chunkIndex);
        }
        catch (Exception e) {
            return true;
        }
    }

    public boolean hasAnyExploredChunks(String worldName, int baseChunkX, int baseChunkZ, int chunksPerAxis) {
        if (!this.plugin.getConfig().isRenderExploredChunksOnly()) {
            return true;
        }
        World world = Universe.get().getWorld(worldName);
        if (world == null) {
            return false;
        }
        try {
            int[][] samplePoints;
            LongSet indexes = this.getCachedChunkIndexes(world);
            if (indexes == null) {
                return true;
            }
            for (int[] point : samplePoints = new int[][]{{0, 0}, {chunksPerAxis - 1, 0}, {0, chunksPerAxis - 1}, {chunksPerAxis - 1, chunksPerAxis - 1}, {chunksPerAxis / 2, chunksPerAxis / 2}}) {
                long idx = ChunkUtil.indexChunk((int)(baseChunkX + point[0]), (int)(baseChunkZ + point[1]));
                if (!indexes.contains(idx)) continue;
                return true;
            }
            for (int dz = 0; dz < chunksPerAxis; ++dz) {
                for (int dx = 0; dx < chunksPerAxis; ++dx) {
                    long idx = ChunkUtil.indexChunk((int)(baseChunkX + dx), (int)(baseChunkZ + dz));
                    if (!indexes.contains(idx)) continue;
                    return true;
                }
            }
            return false;
        }
        catch (Exception e) {
            return true;
        }
    }

    private LongSet getCachedChunkIndexes(World world) {
        String worldName = world.getName();
        CachedChunkIndexes cached = this.chunkIndexCache.get(worldName);
        long now = System.currentTimeMillis();
        if (cached != null && now - cached.timestamp < this.plugin.getConfig().getChunkIndexCacheMs()) {
            return cached.indexes;
        }
        try {
            ChunkStore chunkStore = world.getChunkStore();
            IChunkLoader loader = chunkStore.getLoader();
            if (loader == null) {
                return null;
            }
            LongSet indexes = loader.getIndexes();
            this.chunkIndexCache.put(worldName, new CachedChunkIndexes(indexes, now));
            return indexes;
        }
        catch (Exception e) {
            return cached != null ? cached.indexes : null;
        }
    }

    public CompletableFuture<Integer> pregenerateTiles(String worldName, int centerX, int centerZ, int radius) {
        World world = Universe.get().getWorld(worldName);
        if (world == null) {
            return CompletableFuture.completedFuture(0);
        }
        return CompletableFuture.supplyAsync(() -> {
            int count = 0;
            for (int x = centerX - radius; x <= centerX + radius; ++x) {
                for (int z = centerZ - radius; z <= centerZ + radius; ++z) {
                    if (this.diskCache.exists(worldName, 0, x, z) || this.plugin.getConfig().isRenderExploredChunksOnly() && !this.isChunkExplored(world, x, z)) continue;
                    try {
                        byte[] tile = this.generateTile(worldName, 0, x, z).join();
                        if (tile != null && tile.length > 100) {
                            this.diskCache.put(worldName, 0, x, z, tile);
                            ++count;
                        }
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            return count;
        });
    }

    public void clearCache() {
        this.memoryCache.clear();
        this.pixelCache.clear();
        this.diskCache.clear();
        this.chunkIndexCache.clear();
    }

    public void clearMemoryCache() {
        this.memoryCache.clear();
        this.pixelCache.clear();
    }

    public void shutdown() {
        this.diskCache.shutdown();
    }

    public int getMemoryCacheSize() {
        return this.memoryCache.size();
    }

    public DiskTileCache getDiskCache() {
        return this.diskCache;
    }

    private static class CachedChunkIndexes {
        final LongSet indexes;
        final long timestamp;

        CachedChunkIndexes(LongSet indexes, long timestamp) {
            this.indexes = indexes;
            this.timestamp = timestamp;
        }
    }
}

