/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.map;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;

public class TileCache {
    private final ConcurrentHashMap<String, byte[]> cache;
    private final ConcurrentLinkedDeque<String> accessOrder;
    private final int maxSize;
    private final AtomicInteger size;

    public TileCache(int maxSize) {
        this.maxSize = maxSize;
        this.cache = new ConcurrentHashMap(maxSize);
        this.accessOrder = new ConcurrentLinkedDeque();
        this.size = new AtomicInteger(0);
    }

    public byte[] get(String key) {
        byte[] value = this.cache.get(key);
        if (value != null) {
            this.accessOrder.remove(key);
            this.accessOrder.addLast(key);
        }
        return value;
    }

    public void put(String key, byte[] data) {
        if (this.cache.putIfAbsent(key, data) == null) {
            String oldest;
            this.accessOrder.addLast(key);
            int currentSize = this.size.incrementAndGet();
            while (currentSize > this.maxSize && (oldest = this.accessOrder.pollFirst()) != null && this.cache.remove(oldest) != null) {
                currentSize = this.size.decrementAndGet();
            }
        } else {
            this.cache.put(key, data);
            this.accessOrder.remove(key);
            this.accessOrder.addLast(key);
        }
    }

    public void clear() {
        this.cache.clear();
        this.accessOrder.clear();
        this.size.set(0);
    }

    public int size() {
        return this.size.get();
    }

    public static String createKey(String worldName, int zoom, int x, int z) {
        return worldName + "/" + zoom + "/" + x + "/" + z;
    }
}

