/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.map;

import com.hypixel.hytale.protocol.packets.worldmap.MapImage;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class PngEncoder {
    private static final ConcurrentHashMap<Integer, byte[]> EMPTY_TILE_CACHE = new ConcurrentHashMap();
    private static final ThreadLocal<ImageWriter> PNG_WRITER = ThreadLocal.withInitial(() -> {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        return writers.hasNext() ? writers.next() : null;
    });

    public static byte[] encode(MapImage mapImage, int outputSize) {
        int srcWidth = mapImage.width;
        int srcHeight = mapImage.height;
        int[] srcData = mapImage.data;
        int[] destData = new int[outputSize * outputSize];
        float scaleX = (float)srcWidth / (float)outputSize;
        float scaleY = (float)srcHeight / (float)outputSize;
        for (int y = 0; y < outputSize; ++y) {
            int destRowStart = y * outputSize;
            int srcY = Math.min((int)((float)y * scaleY), srcHeight - 1);
            int srcRowStart = srcY * srcWidth;
            for (int x = 0; x < outputSize; ++x) {
                int srcX = Math.min((int)((float)x * scaleX), srcWidth - 1);
                int rgba = srcData[srcRowStart + srcX];
                int r = rgba >> 24 & 0xFF;
                int g = rgba >> 16 & 0xFF;
                int b = rgba >> 8 & 0xFF;
                destData[destRowStart + x] = r << 16 | g << 8 | b;
            }
        }
        BufferedImage buffered = new BufferedImage(outputSize, outputSize, 1);
        buffered.setRGB(0, 0, outputSize, outputSize, destData, 0, outputSize);
        return PngEncoder.encodeFast(buffered, outputSize);
    }

    public static TileData encodeWithPixels(MapImage mapImage, int outputSize) {
        int srcWidth = mapImage.width;
        int srcHeight = mapImage.height;
        int[] srcData = mapImage.data;
        int[] destData = new int[outputSize * outputSize];
        float scaleX = (float)srcWidth / (float)outputSize;
        float scaleY = (float)srcHeight / (float)outputSize;
        for (int y = 0; y < outputSize; ++y) {
            int destRowStart = y * outputSize;
            int srcY = Math.min((int)((float)y * scaleY), srcHeight - 1);
            int srcRowStart = srcY * srcWidth;
            for (int x = 0; x < outputSize; ++x) {
                int srcX = Math.min((int)((float)x * scaleX), srcWidth - 1);
                int rgba = srcData[srcRowStart + srcX];
                int r = rgba >> 24 & 0xFF;
                int g = rgba >> 16 & 0xFF;
                int b = rgba >> 8 & 0xFF;
                destData[destRowStart + x] = r << 16 | g << 8 | b;
            }
        }
        BufferedImage buffered = new BufferedImage(outputSize, outputSize, 1);
        buffered.setRGB(0, 0, outputSize, outputSize, destData, 0, outputSize);
        byte[] pngBytes = PngEncoder.encodeFast(buffered, outputSize);
        return new TileData(pngBytes, destData, outputSize);
    }

    private static byte[] encodeFast(BufferedImage image, int outputSize) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(outputSize * outputSize / 2);
        ImageWriter writer = PNG_WRITER.get();
        if (writer == null) {
            try {
                ImageIO.write((RenderedImage)image, "png", out);
            }
            catch (IOException e) {
                return new byte[0];
            }
            return out.toByteArray();
        }
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(out);){
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (param.canWriteCompressed()) {
                param.setCompressionMode(2);
                param.setCompressionQuality(1.0f);
            }
            writer.write(null, new IIOImage(image, null, null), param);
            writer.reset();
        }
        catch (IOException e) {
            return new byte[0];
        }
        return out.toByteArray();
    }

    public static byte[] encodeEmpty(int size) {
        return EMPTY_TILE_CACHE.computeIfAbsent(size, s -> {
            BufferedImage buffered = new BufferedImage((int)s, (int)s, 1);
            return PngEncoder.encodeFast(buffered, s);
        });
    }

    public static class TileData {
        public final byte[] pngBytes;
        public final int[] pixels;
        public final int size;

        public TileData(byte[] pngBytes, int[] pixels, int size) {
            this.pngBytes = pngBytes;
            this.pixels = pixels;
            this.size = size;
        }

        public boolean isEmpty() {
            return this.pngBytes == null || this.pngBytes.length < 500;
        }
    }
}

