/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.map;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import javax.imageio.ImageIO;

public class PngDecoder {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int[] decode(byte[] pngBytes, int expectedSize) {
        if (pngBytes == null) return null;
        if (pngBytes.length == 0) {
            return null;
        }
        try (ByteArrayInputStream bais = new ByteArrayInputStream(pngBytes);){
            BufferedImage image = ImageIO.read(bais);
            if (image == null) {
                int[] nArray = null;
                return nArray;
            }
            int width = image.getWidth();
            int height = image.getHeight();
            if (width != expectedSize || height != expectedSize) {
                BufferedImage scaled = new BufferedImage(expectedSize, expectedSize, 1);
                scaled.getGraphics().drawImage(image, 0, 0, expectedSize, expectedSize, null);
                image = scaled;
                width = expectedSize;
                height = expectedSize;
            }
            int[] pixels = new int[width * height];
            image.getRGB(0, 0, width, height, pixels, 0, width);
            int[] nArray = pixels;
            return nArray;
        }
        catch (Exception e) {
            return null;
        }
    }
}

