/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.map;

import com.easywebmap.EasyWebMap;
import com.easywebmap.map.PngEncoder;
import com.easywebmap.map.TileManager;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.ImageOutputStream;

public class CompositeTileGenerator {
    private final EasyWebMap plugin;
    private final TileManager tileManager;
    private final ConcurrentHashMap<String, int[]> pixelCache;
    private static final int MAX_PIXEL_CACHE = 512;
    private static final ThreadLocal<ImageWriter> PNG_WRITER = ThreadLocal.withInitial(() -> {
        Iterator<ImageWriter> writers = ImageIO.getImageWritersByFormatName("png");
        return writers.hasNext() ? writers.next() : null;
    });

    public CompositeTileGenerator(EasyWebMap plugin, TileManager tileManager) {
        this.plugin = plugin;
        this.tileManager = tileManager;
        this.pixelCache = new ConcurrentHashMap();
    }

    public int getChunksPerAxis(int zoom) {
        if (zoom >= 0) {
            return 1;
        }
        return 1 << -zoom;
    }

    public CompletableFuture<byte[]> generateCompositeTile(String worldName, int zoom, int tileX, int tileZ) {
        if (zoom >= 0) {
            return this.tileManager.getBaseTile(worldName, tileX, tileZ);
        }
        int chunksPerAxis = this.getChunksPerAxis(zoom);
        int tileSize = this.plugin.getConfig().getTileSize();
        int baseChunkX = tileX * chunksPerAxis;
        int baseChunkZ = tileZ * chunksPerAxis;
        if (!this.tileManager.hasAnyExploredChunks(worldName, baseChunkX, baseChunkZ, chunksPerAxis)) {
            return CompletableFuture.completedFuture(PngEncoder.encodeEmpty(tileSize));
        }
        ArrayList<CompletionStage> futures = new ArrayList<CompletionStage>();
        for (int dz = 0; dz < chunksPerAxis; ++dz) {
            int dx = 0;
            while (dx < chunksPerAxis) {
                int chunkX = baseChunkX + dx;
                int chunkZ = baseChunkZ + dz;
                int posX = dx++;
                int posZ = dz;
                CompletionStage tileFuture = this.tileManager.getBaseTileWithPixels(worldName, chunkX, chunkZ).thenApply(data -> new TileWithPosition((PngEncoder.TileData)data, posX, posZ));
                futures.add(tileFuture);
            }
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).thenApply(v -> {
            ArrayList<TileWithPosition> tiles = new ArrayList<TileWithPosition>();
            for (CompletableFuture future : futures) {
                tiles.add((TileWithPosition)future.join());
            }
            return this.compositeFromPixels(tiles, chunksPerAxis, tileSize);
        });
    }

    private byte[] compositeFromPixels(List<TileWithPosition> tiles, int chunksPerAxis, int outputSize) {
        int[] compositePixels = new int[outputSize * outputSize];
        int subTileSize = outputSize / chunksPerAxis;
        boolean hasAnyContent = false;
        for (TileWithPosition tile : tiles) {
            if (tile.data == null || tile.data.pixels == null) continue;
            int[] srcPixels = tile.data.pixels;
            int srcSize = tile.data.size;
            if (srcPixels.length == 0) continue;
            hasAnyContent = true;
            int destX = tile.posX * subTileSize;
            int destY = tile.posZ * subTileSize;
            float scale = (float)srcSize / (float)subTileSize;
            for (int y = 0; y < subTileSize; ++y) {
                int destRowStart = (destY + y) * outputSize + destX;
                int srcY = Math.min((int)((float)y * scale), srcSize - 1);
                int srcRowStart = srcY * srcSize;
                for (int x = 0; x < subTileSize; ++x) {
                    int srcX = Math.min((int)((float)x * scale), srcSize - 1);
                    compositePixels[destRowStart + x] = srcPixels[srcRowStart + srcX];
                }
            }
        }
        if (!hasAnyContent) {
            return PngEncoder.encodeEmpty(outputSize);
        }
        BufferedImage composite = new BufferedImage(outputSize, outputSize, 1);
        composite.setRGB(0, 0, outputSize, outputSize, compositePixels, 0, outputSize);
        return this.encodeFast(composite, outputSize);
    }

    private byte[] encodeFast(BufferedImage image, int outputSize) {
        ByteArrayOutputStream out = new ByteArrayOutputStream(outputSize * outputSize / 2);
        ImageWriter writer = PNG_WRITER.get();
        if (writer == null) {
            try {
                ImageIO.write((RenderedImage)image, "png", out);
            }
            catch (IOException e) {
                return PngEncoder.encodeEmpty(outputSize);
            }
            return out.toByteArray();
        }
        try (ImageOutputStream ios = ImageIO.createImageOutputStream(out);){
            writer.setOutput(ios);
            ImageWriteParam param = writer.getDefaultWriteParam();
            if (param.canWriteCompressed()) {
                param.setCompressionMode(2);
                param.setCompressionQuality(1.0f);
            }
            writer.write(null, new IIOImage(image, null, null), param);
            writer.reset();
        }
        catch (IOException e) {
            return PngEncoder.encodeEmpty(outputSize);
        }
        return out.toByteArray();
    }

    public void clearPixelCache() {
        this.pixelCache.clear();
    }

    public static class TileWithPosition {
        final PngEncoder.TileData data;
        final int posX;
        final int posZ;

        TileWithPosition(PngEncoder.TileData data, int posX, int posZ) {
            this.data = data;
            this.posX = posX;
            this.posZ = posZ;
        }
    }
}

