/*
 * Decompiled with CFR 0.152.
 */
package com.easywebmap.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;

public class MapConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Path configFile;
    private ConfigData data;

    public MapConfig(Path dataDirectory) {
        this.configFile = dataDirectory.resolve("config.json");
        this.load();
    }

    private void load() {
        ConfigData defaults = new ConfigData();
        boolean needsSave = false;
        if (Files.exists(this.configFile, new LinkOption[0])) {
            try {
                String json = Files.readString(this.configFile);
                JsonObject jsonObj = JsonParser.parseString((String)json).getAsJsonObject();
                this.data = (ConfigData)GSON.fromJson((JsonElement)jsonObj, ConfigData.class);
                if (this.data == null) {
                    this.data = defaults;
                    needsSave = true;
                } else {
                    if (this.data.enabledWorlds == null) {
                        this.data.enabledWorlds = defaults.enabledWorlds;
                        needsSave = true;
                    }
                    if (!jsonObj.has("renderExploredChunksOnly")) {
                        this.data.renderExploredChunksOnly = defaults.renderExploredChunksOnly;
                        needsSave = true;
                    }
                    if (!jsonObj.has("chunkIndexCacheMs")) {
                        this.data.chunkIndexCacheMs = defaults.chunkIndexCacheMs;
                        needsSave = true;
                    }
                    if (!jsonObj.has("tileRefreshRadius")) {
                        this.data.tileRefreshRadius = defaults.tileRefreshRadius;
                        needsSave = true;
                    }
                    if (!jsonObj.has("tileRefreshIntervalMs")) {
                        this.data.tileRefreshIntervalMs = defaults.tileRefreshIntervalMs;
                        needsSave = true;
                    }
                    if (!jsonObj.has("useDiskCache")) {
                        this.data.useDiskCache = defaults.useDiskCache;
                        needsSave = true;
                    }
                    if (!jsonObj.has("enableTilePyramids")) {
                        this.data.enableTilePyramids = defaults.enableTilePyramids;
                        needsSave = true;
                    }
                    if (!jsonObj.has("enableHttps")) {
                        this.data.enableHttps = defaults.enableHttps;
                        needsSave = true;
                    }
                    if (!jsonObj.has("httpsPort")) {
                        this.data.httpsPort = defaults.httpsPort;
                        needsSave = true;
                    }
                    if (!jsonObj.has("domain")) {
                        this.data.domain = defaults.domain;
                        needsSave = true;
                    }
                    if (!jsonObj.has("acmeEmail")) {
                        this.data.acmeEmail = defaults.acmeEmail;
                        needsSave = true;
                    }
                    if (!jsonObj.has("useProductionAcme")) {
                        this.data.useProductionAcme = defaults.useProductionAcme;
                        needsSave = true;
                    }
                }
            }
            catch (Exception e) {
                this.data = defaults;
                needsSave = true;
            }
        } else {
            this.data = defaults;
            needsSave = true;
        }
        if (needsSave) {
            this.save();
        }
    }

    public void save() {
        try {
            Files.createDirectories(this.configFile.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(this.configFile, new OpenOption[0]);){
                GSON.toJson((Object)this.data, (Appendable)writer);
            }
        }
        catch (Exception e) {
            System.err.println("[EasyWebMap] Failed to save config: " + e.getMessage());
        }
    }

    public void reload() {
        this.load();
    }

    public int getHttpPort() {
        return this.data.httpPort;
    }

    public int getUpdateIntervalMs() {
        return this.data.updateIntervalMs;
    }

    public int getTileCacheSize() {
        return this.data.tileCacheSize;
    }

    public List<String> getEnabledWorlds() {
        return this.data.enabledWorlds;
    }

    public int getTileSize() {
        return this.data.tileSize;
    }

    public int getMaxZoom() {
        return this.data.maxZoom;
    }

    public boolean isWorldEnabled(String worldName) {
        return this.data.enabledWorlds.isEmpty() || this.data.enabledWorlds.contains(worldName);
    }

    public boolean isRenderExploredChunksOnly() {
        return this.data.renderExploredChunksOnly;
    }

    public long getChunkIndexCacheMs() {
        return this.data.chunkIndexCacheMs;
    }

    public int getTileRefreshRadius() {
        return this.data.tileRefreshRadius;
    }

    public long getTileRefreshIntervalMs() {
        return this.data.tileRefreshIntervalMs;
    }

    public boolean isUseDiskCache() {
        return this.data.useDiskCache;
    }

    public boolean isEnableTilePyramids() {
        return this.data.enableTilePyramids;
    }

    public boolean isHttpsEnabled() {
        return this.data.enableHttps;
    }

    public int getHttpsPort() {
        return this.data.httpsPort;
    }

    public String getDomain() {
        return this.data.domain;
    }

    public String getAcmeEmail() {
        return this.data.acmeEmail;
    }

    public boolean isProductionAcme() {
        return this.data.useProductionAcme;
    }

    private static class ConfigData {
        int httpPort = 8080;
        int updateIntervalMs = 1000;
        int tileCacheSize = 20000;
        List<String> enabledWorlds = new ArrayList<String>();
        int tileSize = 256;
        int maxZoom = 4;
        boolean renderExploredChunksOnly = true;
        long chunkIndexCacheMs = 30000L;
        int tileRefreshRadius = 5;
        long tileRefreshIntervalMs = 60000L;
        boolean useDiskCache = true;
        boolean enableTilePyramids = true;
        boolean enableHttps = false;
        int httpsPort = 8443;
        String domain = "";
        String acmeEmail = "";
        boolean useProductionAcme = true;

        private ConfigData() {
        }
    }
}

